//
//  RootViewController.m
//  Presidents
//
//  Created by Robert Górczyński on 11-07-11.
//

#import "RootViewController.h"
#import "DetailViewController.h"


@implementation RootViewController

@synthesize detailViewController;
@synthesize presidents;

#pragma mark -
#pragma mark Cykl życiowy widoku

- (void)viewDidLoad {
    [super viewDidLoad];
    self.clearsSelectionOnViewWillAppear = NO;
    self.contentSizeForViewInPopover = CGSizeMake(320.0, 600.0);
	NSString *path = [[NSBundle mainBundle] pathForResource:@"PresidentList" 
													 ofType:@"plist"]; 
    NSDictionary *presidentInfo = [NSDictionary dictionaryWithContentsOfFile:path]; 
    self.presidents = [presidentInfo objectForKey:@"presidents"]; 	
}

// Zagwarantowanie, że kontroler widoku obsługuje rotację, a tym samym widok podzielony może być wyświetlany zarówno w układzie pionowym jak i poziomym.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    return YES;
}


#pragma mark -
#pragma mark TableView źródła danych

- (NSInteger)numberOfSectionsInTableView:(UITableView *)aTableView {
    // Zwrot liczby sekcji.
    return 1;
}


- (NSInteger)tableView:(UITableView *)aTableView numberOfRowsInSection:(NSInteger)section {
    // Zwrot liczby rekordów w sekcji.
    return [self.presidents count];
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    static NSString *CellIdentifier = @"CellIdentifier";
    
    // Usunięcie komórki z kolejki lub utworzenie komórki odpowiedniego typu.
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier] autorelease];
        cell.accessoryType = UITableViewCellAccessoryNone;
    }
    
    // Konfiguracja komórki.
    NSDictionary *president = [self.presidents objectAtIndex:indexPath.row];
	cell.textLabel.text = [president objectForKey:@"name"];
    return cell;
}

#pragma mark -
#pragma mark Metody delegata TableView

- (void)tableView:(UITableView *)aTableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    
    /*
     Kiedy rekord jest wybrany, kontroler widoku szczegółowego wyświetli informacje szczegółowe dotyczące wybranego rekordu.
     */
    NSDictionary *president = [self.presidents objectAtIndex:indexPath.row];
    NSString *urlString = [president objectForKey:@"url"];
    detailViewController.detailItem = urlString;	
}


#pragma mark -
#pragma mark Zarządzanie pamięcią

- (void)didReceiveMemoryWarning {
    // Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
    
    // Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}

- (void)viewDidUnload {
    // Usunięcie wszystkiego, co może być ponownie utworzone w metodzie viewDidLoad lub na żądanie,
    // na przykład: self.myOutlet = nil;
    self.presidents = nil; 
}


- (void)dealloc {
    [presidents release];
	[detailViewController release];
    [super dealloc];
}


@end

